import numpy as np
import random

project_matrix1 = np.random.uniform(-0.5, 0.5, 50 * 200)
project_matrix2 = np.random.uniform(-0.5, 0.5, 50 * 100)

project_matrix1 = project_matrix1.reshape(200, 50)
project_matrix2 = project_matrix2.reshape(100, 50)

target = np.random.randn(50)
norm_target = target / np.sqrt(np.sum(target ** 2))
filename = "cor.data"
samples = []

while len(samples) < 2500:
    v = np.random.randn(50)

    norm_v = v / np.sqrt(np.sum(v ** 2))
    if np.dot(norm_target, norm_v) > 0.1:
        label = 1
    else:
        continue
    print(len(samples))
    norm_v = norm_v.reshape(50, 1)

    norm_t = project_matrix2 @ norm_v
    norm_v = project_matrix1 @ norm_v
    norm_v = norm_v.reshape(200)
    norm_t = norm_t.reshape(100)

    samples.append((norm_v, norm_t, label))

while len(samples) < 5000:
    v = np.random.randn(50)

    norm_v = v / np.sqrt(np.sum(v ** 2))
    if np.dot(norm_target, norm_v) < -0.1:
        label = 0
    else:
        continue
    print(len(samples))
    norm_v = norm_v.reshape(50, 1)

    norm_t = project_matrix2 @ norm_v

    norm_v = project_matrix1 @ norm_v
    norm_v = norm_v.reshape(200)
    norm_t = norm_t.reshape(100)

    samples.append((norm_v, norm_t, label))

random.shuffle(samples)

import pickle

with open(filename, "wb") as f:
    pickle.dump(samples, f)